<?php

$fileName = 'webeditor.zip';
$targeturl = "/" . str_replace('installWE.php', 'webeditor', $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
$url = "http://www.perschke.info/webprog/webeditor/download/$fileName?t=instwe%20$targeturl";

$instfileAvailable = file_exists($fileName);
$instdirAvailable = file_exists('webeditor');
$instInstAvailable = file_exists('webeditor/installation.txt');
$instCustAvailable = file_exists('webeditor/customizing.txt');

//DOWNLOAD
function download() {
	global $fileName;
	global $url;
	//DOWNLOAD 1
	$downloadedFileContents = file_get_contents($url);

	if($downloadedFileContents === false){
		throw new Exception('Fehler beim Download der Datei: ' . $url);

		//DOWNLOAD 2
		$fp = fopen($fileName, 'w+');

		if($fp === false){
			throw new Exception('Fehler beim Öffnen der Datei: ' . $fileName);
		}
		$ch = curl_init($url);
		curl_setopt($ch, CURLOPT_FILE, $fp);
		curl_setopt($ch, CURLOPT_TIMEOUT, 20);
		curl_exec($ch);

		if(curl_errno($ch)){
			throw new Exception(curl_error($ch));
		}

		$statusCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		curl_close($ch);
		fclose($fp);

		if($statusCode == 200){
			echo 'Download erfolgreich!';
		} else{
			echo "Status Code: " . $statusCode;
		}
	}

	$save = file_put_contents($fileName, $downloadedFileContents);

	if($save === false){
		throw new Exception('Fehler beim Speichern der Datei: ' , $fileName);
	}
}


//UNZIP
function unzip() {
	global $fileName;
	$zip = new ZipArchive;
	if ($zip->open($fileName) === TRUE) {
		$zip->extractTo('./');
		$zip->close();

		unlink('webeditor/installation.txt');
		unlink('webeditor/customizing.txt');
		$fp = fopen('webeditor/installation.txt', 'w');
		fwrite($fp, 'Entpackt am ' . date('d:m:Y H:i:s') ."\n");
		fclose($fp);

		echo 'Entpacken erfolgreich';
	} else {
		throw new Exception('Fehler beim Entpacken der Datei: ' , $fileName);
	}
}

//CUSTOMIZING
function customize() {
	global $targeturl;
	global $fileName;

	$fileIn = "webeditor/config_template.php";

	$file_handle = fopen($fileIn, 'r');

	$content = "";
	while (!feof($file_handle)) {
	  $line = fgets($file_handle);
	  if(strpos($line, 'define("BASE_PATH",') !== false) {
		  $line = 'define("BASE_PATH", "' . str_replace("\\", "/", dirname(__FILE__)) . '/webeditor");';
	  }
	  if(strpos($line, 'define("BASE_URL",') !== false) {
		$line = 'define("BASE_URL", "' . $targeturl . '");';
	  }
	  $content .= $line;
	}
	 
	fclose($file_handle);

	$fileOut = "webeditor/config.php";
	file_put_contents($fileOut, $content);

	unlink('webeditor/customizing.txt');
	$fp = fopen('webeditor/customizing.txt', 'w');
	fwrite($fp, 'Angepasst am ' . date('d:m:Y H:i:s') ."\n");
	fclose($fp);
	
	if(1*phpversion() >= 7.2) {
		copy('webeditor/lib/diff_match_patch_7.2.php', 'webeditor/lib/diff_match_patch.php');
	}

}

//CLEANUP
function cleanup() {
	global $fileName;

	unlink($fileName);
}

//uninstall
function uninstall() {
	global $fileName;
	unlink($fileName);
	$it = new RecursiveDirectoryIterator('webeditor', RecursiveDirectoryIterator::SKIP_DOTS);
	$files = new RecursiveIteratorIterator($it,	RecursiveIteratorIterator::CHILD_FIRST);
	foreach($files as $file) {
		if ($file->isDir()){
			rmdir($file->getRealPath());
		} else {
			unlink($file->getRealPath());
		}
	}
	rmdir('webeditor');
}

if(isset($_POST['action'])) {
	if($_POST['action'] == 'download') {
		download();
	}
	if($_POST['action'] == 'unzip') {
		unzip();
	}
	if($_POST['action'] == 'customize') {
		customize();
	}
	if($_POST['action'] == 'cleanup') {
		cleanup();
	}
	if($_POST['action'] == 'uninstall') {
		uninstall();
	}
}

?>
<html>

  <head>
    <title>Installation Webeditor</title>
	<meta charset="utf-8">
	<script src="http://code.jquery.com/jquery-3.3.1.min.js"  integrity="sha256-FgpCb/KJQlLNfOu91ta32o/NMZxltwRo8QtmkMRdAu8="  crossorigin="anonymous"></script>
	<style>
		* {
			font-family: Verdana;
		}
		body {
			margin: 50px;
		}
		body>section {
			margin: 50px 0;
			padding: 20px;
			border: 1px solid #000;
			border-radius: 5px;
			background-color: #eee;
		}
		h1, h2 {
			font-variant: small-caps;
		}
		h1 {
			letter-spacing: 4px;
		}
		h2 {
			margin-bottom: 16px;
		}
		p {
			margin-bottom: 10px;
		}
		ul {
			margin: 10px 20px;
		}
		code {
			font-family: monospace;
			font-size: 16px;
		}
		form {
			margin: 20px 0;
		}
		button {
			width: 200px;
		}
		table {
			margin: 20px;
		}
		td, th {
			padding: 8px;
		}
		.success, .failure {
			display: inline-block;
			margin: 0 10px;
			width: 12px;
			height: 12px;
			border-radius: 50%;
		}
		.success {
			background-color: green;
			border: 1px solid green;
		}
		.failure {
			background-color: red;
			border-left: 1px solid red;
			border-right: 1px solid red;
		}

		section section {
			margin: 20px 20px 50px 20px;
		}

		section>header, section>main, section>footer {
			padding: 10px;
		}

		section>header {
			font-weight: bold;
			background-color: #666;
			color: #fff;
			border: 1px solid #666;
			border-top-right-radius: 5px;
			border-top-left-radius: 5px;
		}

		section>main {
			border-left: 4px solid #666;
			border-right: 4px solid #666;
		}

		section>footer {
			padding: 4px;
			border: 1px solid #666;
			background-color: #666;
			color: #fff;
			border-bottom-right-radius: 5px;
			border-bottom-left-radius: 5px;
		}

		.modal {
			display: none;
			position: fixed;
			z-index: 1;
			left: 0;
			top: 0;
			width: 100%;
			height: 100%;
			overflow: auto;
			background-color: rgb(0,0,0);
			background-color: rgba(0,0,0,0.4);
		}

		.modal-content {
			background-color: #fefefe;
			margin: 15% auto;
			padding: 20px;
			border: 1px solid #888;
			width: 50%;
		}
	</style>
  </head>

  <body>
	<h1>Installation Webeditor</h1>
	<div style="font-size: 10px; margin-bottom:40px; margin-left: 20px;">Version: 22.03.2019, Thomas Perschke [PHP-Version: <?=phpversion()?>]</div>
	
	<section>
		
		Mit Hilfe dieser Seite können Sie den Webeditor auf dem Webserver installieren.
		
		<h2>Einleitung</h2>
		<p>
			Bei dem <strong>Webeditor</strong> handelt es sich um eine webbasierte Entwicklungsumgebung auf Basis der Open Source-Software 
			<a href="http://codiad.com/" target="_blank">Codiad</a>. Diese wurde so angepasst, dass ein sinnvoller Einsatz im Rahmen des 
			schulischen Unterrichts möglich ist. Der Webeditor muss auf einem Webserver installiert	werden. Sollte die Schule keinen solchen
			zur Verfügung haben, kann ein entsprechendes Paket bei einem Webhoster abgeschlossen werden. Dabei reicht oft das kleinste Paket
			aus, für den Betrieb des Webeditors wird keine Datenbank benötigt. Ein Vergleich verschiedener Anbieter finden Sie beispielsweise 
			auf den Seiten vom <a href="https://www.stern.de/vergleich/webhosting/" target="_blank">Stern</a>. Es gibt auch kostenlose Angebote,
			die sich durchaus eignen. <a href="https://www.bplaced.net/" target="_blank">bplaced</a> bietet beispielsweise kostenlosen Webspace 
			mit FTP-Zugang und vielen weiteren Features an.
		</p>

		<p style="font-style: italic;">
			<strong>Nur Für Spezialisiten</strong><br>
			Versierte Anwender können auch den Kleinstcomputer Raspberry nutzen und diesen an einen Router (zzgl. Weiterleitung und DynDNS-Dienst) anschließen. 
			Hört sich komplizierter an, als es tatsächlich ist. Handelt es sich bei dem Router um eine Fritzbox, dann lässt sich dies sehr einfach realisieren!
		</p>
				
		<p>
			Die Installation des Webeditors ist weitestgehend automatisiert, diese Seite soll Ihnen dabei helfen. Nach erfolgreicher Installation können vom
			<i>Administrator</i> Schüler und Projekte angelegt werden. Hierfür stehen vorinstallierte PlugIns bereit, die das Anlegen größtenteils automatisieren.
			Die Schüler können sich mit ihren persönlichen Zugangsdaten anmelden und erhalten nur Zugriff auf das ihnen zugeordnete Projekt. Der Administrator 
			kann jederzeit alle Projekte einsehen. 
		</p>
				
		<p>
			Bei Nutzung des Webeditors werden keine weitere Programme (Editoren, Server,...) benötigt. Die Schüler können nicht nur innerhalb
			der Schule an ihren Seiten arbeiten, sondern ohne Weiteres auch vom heimischen PC. Da die Daten zentral auf dem Webserver vorliegen,
			arbeiten die Schüler immer mit dem aktuellen Stand, ein Kopieren der Arbeitsergebnisse zwischen Schule und Zuhause entfällt. 
			Zusätzlich sind die Ergebnisse einfach und dauerhaft über das Internet abrufbar, auch von einem Smartphone aus. Die Verwendung
			des Webeditors im Unterricht setzt einen freigeschalteten Internetzugang voraus. (Prinzipiell ist auch eine schulinterne
			Installation denkbar, so dass die Nutzung auch ohne Internetzugang möglich ist.)
		</p>

		<p>
		  Wenden Sie sich bei Fragen an <code style="margin-left:20px;">webeditor[at]perschke.info</code>.
		</p>

	</section>
	

	<section>
		<h2>Vorbereitung</h2>
		Diese Datei 'instWE.php" muss sich in dem Verzeichnis befinden, in welchem der Webeditor installiert werden soll.
		Das Installationsverzeichnis lautet aktuell: <code><?=  'http://'.$targeturl ?></code>. Unter dieser Adresse wird
		der Webeditor nach der Installation erreichbar sein.
	</section>
	
	<?php if($instCustAvailable){ ?>
	<section>
		<h2>Wichtige Informationen</h2>
		Der Webeditor ist installiert. 
		<table>
		<tr>
				<td>Adresse des Webeditors:</td>
				<td><a href="<?=  'http://'.$targeturl ?>" target="_blank"><code><?=  'http://'.$targeturl ?></code></a></td>
			</tr>
			<tr>
				<td>Benutzername des Administrator:</td>
				<td><code>adm</code></td>
			</tr>
			<tr>
				<td>Initiales Kennwort des Administrator:</td>
				<td><code>12345</code></td>
			</tr>
		</table>
		<strong>Was ist nach der Installation zu tun?</strong><br>
		<p>
		Nach erfolgreicher Anmeldung im Webeditor finden Sie mittig am rechten Rand ein "Hamburger-Menü". Befindet sich die Maus über
		den drei horizontalen Strichen, öffnet sich ein Menü. Hier können Sie verschiedene Einstellungen vornehmen und Schüler und/oder
		Projekte anlegen. Auch Schüler können dieses Menü einsehen, haben allerdings weniger Einstellungsmöglichkeiten. Auf der linken
		Seite befindet sich der Projektbaum. Ein Klick mit der rechten Maustaste öffnet ein Kontextmenü. Sie können so neue Verzeichnisse
		oder Dateien anlegen oder eine Datei im Browser zur Ansicht öffnen (--> <code>preview</code>). Ein Doppelklick auf eine Datei
		im Projektbaum öffnet diese im Editor. Das Speichern der Änderungen in einer Datei erfolgt über das Hamburger-Menü oder
		per Tastenkomination <code>STRG+S</code>.
		</p>
		<p>
			<strong>ToDo</strong>
			<ol>
				<li>Ändern Sie unbedingt das Kennwort des Administrators (Benutzername: <code>adm</code>)</li>
				<li>Legen Sie Schüler und Projekte an, ordnen Sie die Schüler ihren Projekten zu. Laden Sie dazu eine von Untis exportierte
					csv-Datei in den Explorer des Webeditors und rufen Sie im Kontextmenü den Eintrag "Schülerimport" auf. Für jeden in der 
					hochgeladenen Datei aufgeführten Schüler wird automatisch ein Projekt und ein User angelegt. Den Schülern wird ihr 
					Projekt zugeordnet. Die Zugangsdaten werden automatisch generiert und in die hochgeladene Datei integriert.
					
				</li>
			</ol>
			Eine Anleitung für die Bedienung des Webeditors ist aktuell in Arbeit. Bei Fragen einfach eineMail an
			webeditor[at]perschke.info senden.
		</p>
	</section>
	<?php } ?>
	

	<section>
		<h2>Installation</h2>

		<p>
		  Für eine erfolgreiche Installation müssen für die Schritte 1 bis 3 grüne Lampen angezeigt werden!
		</p>

		<section>
			<header>Schritt 1: Aktuelles Installationspaket bereitstellen</header>
			<main>
				Für die Installation des Webeditors wird das Installationspaket "webeditor.zip"	benötigt. Die Bereitstellung kann automatisch
				durch Klick auf folgende Schaltfläche erfolgen. Auf manchen Accounts ist dies nicht möglich. Sollte die automatische
				Bereitstellung nicht funktionieren, dann müssen Sie das Paket manuell 
				<a href="http://www.perschke.info/webprog/webeditor/download/webeditor.zip?t=instwe_man <?=  str_replace('webeditor', '', $targeturl) ?>">downloaden</a> und in 
				das Verzeichnis  <code><?=  str_replace('webeditor', '', 'http://'.$targeturl) ?></code> Ihres Webservers kopieren bzw.
				hochladen.
				<?php if(strpos($targeturl, '.bplaced.net') !== false) { ?>
				<p style="color: orange;">
					Hinweis: Sie nutzen den Webspace von bplaced.net. Eine automatische Bereitstellung des Installationspaketes
					ist hier nicht möglich. Bitte laden Sie dies <a href="http://www.perschke.info/webprog/webeditor/download/webeditor.zip?t=instwe_man <?=  str_replace('webeditor', '', $targeturl) ?>">manuell</a>
					und kopieren Sie dies auf den Webspace ins gleiche
					Verzeichnis, wo sich auch die Datei <code>instWE.php</code> befindet.
				</p>
				<?php } ?>
				<form action="#">
					<button id="download">Paket automatisch bereitstellen</button>
				</form>
			</main>
			<footer>
			<?php if($instfileAvailable) { ?>
				<div class="success"></div>Das Installationspaket steht bereit
			<?php } else {?>
				<div class="failure"></div>Das Installationspaket wurde nicht erkannt 
				<?= $instCustAvailable?' - nicht schlimm, der Webeditor ist bereits installiert ;)':'' ?>

			<?php } ?>
			</footer>
		</section>

		<section>
			<header>Schritt 2: Installationspaket entpacken</header>
			<main>
				In diesem Schritt wird das Verzeichnis <code><?=  dirname(__FILE__) . '/webeditor'  ?></code> erstellt und alle notwendigen Dateien dort hineinkopiert.
				<form action="#">
					<button id="unzip" <?= $instfileAvailable?'':'disabled'?>>Paket entpacken</button>
				</form>
			</main>
			<footer>
			<?php if($instdirAvailable) { ?>
				<div class="success"></div>Das Installationspaket ist entpackt <?= file_exists('webeditor/version.txt')?'- Paketversion ' . file_get_contents('webeditor/version.txt'):'' ?>
			<?php } else {?>
				<div class="failure"></div>Das Installationspaket ist noch nicht entpackt
			<?php } ?>
			</footer>
		</section>

		<section>
			<header>Schritt 3: Installation anpassen</header>
			<main>
				Der Webeditor ist erst funktionsfähig, nachdem einige Einstellungen angepasst wurden. Dabei handelt es sich vor allem
				um Anpassung von Pfaden.
				<form action="#">
					<button id="customize" <?= $instInstAvailable?'':'disabled'?>>Installation anpassen</button>
				</form>
			</main>
			<footer>
			<?php if($instCustAvailable) { ?>
				<div class="success"></div>Die Installation ist angepasst
			<?php } else {?>
				<div class="failure"></div>Die Installation ist noch nicht angepasst
			<?php } ?>
			</footer>
		</section>

		<section>
			<header>Schritt 4: Installation aufräumen</header>
			<main>
				Nicht alle bei der Installation erstellten Dateien sind auch für den Betrieb notwendig. Sie können die nicht benötigten
				Reste der Installation einfach entfernen.
				<form action="#">
					<button id="cleanup" <?= ($instCustAvailable && $instfileAvailable)?'':'disabled'?>>Reste der Installation aufräumen</button>
				</form>
			</main>
			<footer>
			<?php if($instCustAvailable && !$instfileAvailable) { ?>
				<div class="success"></div>Es gibt keine unnötigen Reste, die Installation ist aufgeräumt
			<?php } else {?>
				<div class="failure"></div>Die Reste der Installation könnten noch aufgeräumt werden
			<?php } ?>
			</footer>
		</section>

		<section>
			<header style="color:#f00;">Deinstallation!</header>
			<main style="background-color:#faa;">
				Sollte ein Installationsversuch nicht geklappt habe oder Sie wollen den Webeditor nicht weiter nutzen, dann können
				Sie hier den Webeditor wieder deinstallieren. Achtung: Dabei werden alle Einstellungen und auch alle Projekte 
				ohne Nachfrage gelöscht!
				<p>
				Die Datei 'instWE.php' wird nicht gelöscht.
				</p>
				<form action="#">
					<button id="uninstall" <?= ($instdirAvailable || $instfileAvailable)?'':'disabled'?>>Deinstallieren</button>
				</form>
			</main>
			<footer>
			<?php if(!$instCustAvailable && !$instfileAvailable) { ?>
				<div class="failure"></div>Der Webeditor ist nicht installiert
			<?php } ?>
			</footer>
		</section>
	</section>

	<div id="myModal" class="modal">
		<div class="modal-content">
		</div>
	</div>  

	<script>
		// Get the modal
		var modal = document.getElementById('myModal');

		function showModal(text) {
			$('#myModal .modal-content')[0].innerHTML = text;
			modal.style.display = "block";
		}

		function closeModal() {
			modal.style.display = "none";
		}

		$('form').on('submit', function(){
			return false;
		})
		$('#download').on('click', function(){
			showModal("Das Installationspaket wird geladen, bitte warten...");
			$.post(
				'installWE.php',
				{
					action: 'download'
				},
				function(data) {
					console.log(data);
					closeModal();
					location.reload();
				},
				'html'
			);
		});
		$('#unzip').on('click', function(){
			showModal("Das Installationspaket wird entpackt, bitte warten...");
			$.post(
				'installWE.php',
				{
					action: 'unzip'
				},
				function(data) {
					closeModal();
					location.reload();
				},
				'html'
			);
		});
		$('#customize').on('click', function(){
			showModal("Die Installation wird angepasst, bitte warten...");
			$.post(
				'installWE.php',
				{
					action: 'customize'
				},
				function(data) {
					closeModal();
					location.reload();
				},
				'html'
			);
		});
		$('#cleanup').on('click', function(){
			showModal("Es wird aufgeräumt, bitte warten...");
			$.post(
				'installWE.php',
				{
					action: 'cleanup'
				},
				function(data) {
					closeModal();
					location.reload();
				},
				'html'
			);
		});
		$('#uninstall').on('click', function(){
			showModal("Der Webeditor wird deinstalliert, bitte warten...");
			$.post(
				'installWE.php',
				{
					action: 'uninstall'
				},
				function(data) {
					closeModal();
					location.reload();
				},
				'html'
			);
		});
	</script>
  </body>

</html>